/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FilterProperties;
import cds.aladin.HealpixAllskyCat;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyCat;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.Source;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.moc.SMoc;
import cds.tools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PlanBGCat
extends PlanBG {
    protected static final int MAXGAPORDER = 3;
    private int gapOrder = 0;
    protected int allskyExt = 3;
    private Pcat genericPcat;
    private HealpixAllskyCat[] allsky = new HealpixAllskyCat[4];
    protected double completude = 0.0;
    private int oNbObj = -1;
    private int oHashObj = -1;

    protected PlanBGCat(Aladin aladin) {
        super(aladin);
        this.type = 18;
    }

    protected PlanBGCat(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin, gluSky, label, c, radius, startingTaskId);
        aladin.log(Plan.Tp[this.type], label);
        this.setAllskyExt();
    }

    @Override
    protected int getTileMode() {
        return 2;
    }

    protected int getGapOrder() {
        return this.gapOrder;
    }

    protected void setGapOrder(int gapOrder) {
        if (Math.abs(gapOrder) > 3) {
            return;
        }
        this.gapOrder = gapOrder;
    }

    @Override
    protected void setSpecificParams(TreeObjDir gluSky) {
        this.type = 18;
        this.c = Couleur.getNextDefault(this.aladin.calque);
        this.setOpacityLevel(1.0f);
        this.frameOrigin = gluSky.getFrame();
        this.scanProperties();
        this.loadGenericLegende();
    }

    @Override
    protected boolean isCatalog() {
        return true;
    }

    @Override
    protected boolean isTime() {
        return this.isCatalogTime();
    }

    @Override
    protected boolean isSync() {
        boolean isSync = super.isSync();
        isSync = isSync && (this.planFilter == null || this.planFilter.isSync());
        return isSync;
    }

    @Override
    protected void suiteSpecific() {
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        this.allsky = null;
        if (this.error == null) {
            this.loader = new PlanBG.HealpixLoader();
        }
    }

    @Override
    protected void log() {
    }

    @Override
    protected boolean isFullyDrawn() {
        return this.readyDone && this.allWaitingKeysDrawn;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        int n = this.getCounts();
        if (n > 0) {
            PlanBGCat.ADD(buf, "\n* Sources loaded: ", String.format("%,d", n));
        }
        try {
            String s = prop.getFirst("nb_rows");
            if (s != null) {
                PlanBGCat.ADD(buf, "\n* Total: ", String.format("%,d", Long.parseLong(s)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlanBGCat.ADD(buf, "\n", "* HiPS order: " + this.getOrder() + "/" + this.maxOrder);
    }

    @Override
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op, boolean now) {
        if (v == null) {
            return;
        }
        if (op == -1.0f) {
            op = this.getOpacityLevel();
        }
        if ((double)op <= 0.1) {
            return;
        }
        if (g instanceof Graphics2D) {
            Composite saveComposite;
            Graphics2D g2d;
            block8: {
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                try {
                    if ((double)op < 0.9) {
                        Composite myComposite = Util.getImageComposite(op);
                        g2d.setComposite(myComposite);
                    }
                    this.draw(g2d, v);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block8;
                    e.printStackTrace();
                }
            }
            g2d.setComposite(saveComposite);
        } else {
            this.draw(g, v);
        }
        this.readyDone = this.readyAfterDraw;
    }

    @Override
    protected void clearBuf() {
    }

    @Override
    protected HealpixKey getHealpixFromAllSky(int order, long npix) {
        return null;
    }

    @Override
    public HealpixKey askForHealpix(int order, long npix) {
        this.readyAfterDraw = false;
        HealpixKeyCat pixAsk = new HealpixKeyCat(this, order, npix);
        this.pixList.put(this.key(order, npix), pixAsk);
        return pixAsk;
    }

    @Override
    protected int getTileOrder() {
        return 9;
    }

    protected boolean drawAllSky(Graphics g, ViewSimple v, int order) {
        boolean hasDrawnSomething = false;
        if (this.allsky[order] == null) {
            this.allsky[order] = new HealpixAllskyCat((PlanBG)this, order, this.allskyExt);
            this.pixList.put(this.key(order, -1L), this.allsky[order]);
            if (this.local) {
                this.allsky[order].loadFromNet();
            } else {
                if (!this.useCache || !this.allsky[order].isCached()) {
                    this.tryWakeUp();
                    return true;
                }
                this.allsky[order].loadFromCache();
                this.pourcent = -1.0;
            }
        }
        if (this.allsky[order].getStatus() == 6) {
            hasDrawnSomething = this.allsky[order].draw(g, v) > 0;
        }
        return hasDrawnSomething;
    }

    @Override
    protected int adjustMaxOrder(int lastMaxOrder, double pixSize) {
        return lastMaxOrder;
    }

    protected int getCurrentMaxOrder(ViewSimple v) {
        return Math.max(1, Math.min(this.maxOrder(v) + this.gapOrder, this.maxOrder));
    }

    private void resetDrawnInView(ViewSimple v) {
        Enumeration e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKeyCat healpix = (HealpixKeyCat)e.nextElement();
            if (healpix == null) continue;
            healpix.resetDrawnInView(v);
        }
    }

    @Override
    protected int getMinOrder() {
        return this.minOrder == -1 ? 1 : this.minOrder;
    }

    protected void draw(Graphics g, ViewSimple v) {
        long[] pix = null;
        int order = this.getCurrentMaxOrder(v);
        int nb = 0;
        boolean allKeyReady = true;
        long nLoaded = 0L;
        long nTotal = 0L;
        boolean allsky1 = false;
        boolean allsky2 = false;
        boolean allsky3 = false;
        boolean hipsOld = this.allskyExt == 3;
        int minOrder = hipsOld ? 3 : this.getMinOrder();
        SMoc lastMoc = new SMoc();
        this.resetDrawnInView(v);
        if (!hipsOld) {
            allsky1 = this.drawAllSky(g, v, 1);
        }
        if (hipsOld || order >= 2) {
            allsky2 = this.drawAllSky(g, v, 2);
        }
        if (order >= 3) {
            allsky3 = this.drawAllSky(g, v, 3);
        }
        this.hasDrawnSomething = allsky1 || allsky2 || allsky3;
        this.setMem();
        this.resetPriority();
        boolean moreDetails = order <= 3;
        for (int norder = minOrder; norder <= order; ++norder) {
            if (!hipsOld && (norder == 1 && this.allsky[1].getStatus() != 7 || norder == 2 && this.allsky[2].getStatus() != 7 || norder == 3 && this.allsky[3].getStatus() != 7)) continue;
            pix = this.getPixListView(v, norder);
            if (pix == null) {
                return;
            }
            for (int i = 0; i < pix.length; ++i) {
                int status;
                HealpixKeyCat healpix;
                if (lastMoc.isIncluding(norder, pix[i]) || this.isOutMoc(norder, pix[i]) || new HealpixKey(this, norder, pix[i], 0).isOutView(v) || (healpix = (HealpixKeyCat)this.getHealpix(norder, pix[i], true)) == null || (status = healpix.getStatus()) == 7) continue;
                if (status == 8) {
                    healpix.setStatus(1, true);
                }
                healpix.priority = 250 - this.priority++;
                healpix.resetTimer();
                if (norder == order && status != 6) {
                    allKeyReady = false;
                }
                if (status != 6) {
                    moreDetails = true;
                    continue;
                }
                nb += healpix.draw(g, v);
                if (norder != order) {
                    if (!healpix.isLast()) continue;
                    try {
                        lastMoc.add(healpix.order, healpix.npix);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                HealpixKeyCat h = healpix;
                if (!moreDetails && !h.isReallyLast(v)) {
                    moreDetails = true;
                }
                nLoaded += (long)h.nLoaded;
                nTotal += (long)h.nTotal;
            }
        }
        this.drawTilesWithSelection(g, v, order);
        if (allKeyReady) {
            double p1;
            double d = this.completude = nTotal != 0L && nLoaded == nTotal ? 100.0 : 100.0 * ((double)order / (double)this.maxOrder);
            if (nTotal != 0L && (p1 = 100.0 * ((double)nLoaded / (double)nTotal)) > this.completude) {
                this.completude = p1;
            }
        }
        if (!moreDetails) {
            this.completude = 100.0;
        }
        this.setHasMoreDetails(order >= this.getMaxFileOrder() ? false : moreDetails);
        this.allWaitingKeysDrawn = allKeyReady;
        boolean bl = this.hasDrawnSomething = this.hasDrawnSomething || nb > 0;
        if (moreDetails) {
            this.tryWakeUp();
        }
    }

    private int drawTilesWithSelection(Graphics g, ViewSimple v, int order) {
        int nb = 0;
        for (HealpixKey healpix : this.pixList.values()) {
            if (healpix.order <= order || healpix.getStatus() != 6 || !((HealpixKeyCat)healpix).pcat.hasSelectedOrTaggedObj() || healpix.isOutView(v)) continue;
            nb += ((HealpixKeyCat)healpix).drawOnlySelected(g, v);
        }
        return nb;
    }

    @Override
    protected double getCompletude() {
        return this.completude;
    }

    @Override
    protected void askForRepaint() {
        int nbObj = this.getCounts();
        int hashObj = 0;
        boolean flagUpdate = false;
        if (this.oNbObj != nbObj) {
            flagUpdate = true;
        } else {
            hashObj = this.hashSrc();
            if (hashObj != this.oHashObj) {
                flagUpdate = true;
            }
        }
        if (flagUpdate) {
            this.oNbObj = nbObj;
            if (hashObj == 0) {
                hashObj = this.hashSrc();
            }
            this.oHashObj = hashObj;
            this.updateDedicatedFilter();
        }
        this.aladin.view.repaintAll();
    }

    private int hashSrc() {
        int hash = 0;
        Iterator<Obj> it = this.iterator();
        if (it == null) {
            return hash;
        }
        while (it.hasNext()) {
            Obj obj = it.next();
            hash += 31 * obj.hashCode();
        }
        return hash;
    }

    @Override
    protected void planReady(boolean ready) {
        super.planReady(ready);
        this.setFilter(this.filterIndex);
        this.askForRepaint();
    }

    @Override
    protected boolean Free() {
        this.aladin.view.deSelect(this);
        super.Free();
        this.genericPcat = null;
        FilterProperties.notifyNewPlan();
        return true;
    }

    @Override
    protected void purge(HealpixKey healpix) {
        int n = ((HealpixKeyCat)healpix).free(false);
        if (n == 0) {
            return;
        }
        this.nbFlush += n;
        if (this.nbFlush > 2000) {
            this.gc();
        }
        this.pixList.remove(this.key(healpix));
    }

    @Override
    protected void resetProj(int n) {
        this.proj[n] = null;
        Enumeration e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKeyCat healpix = (HealpixKeyCat)e.nextElement();
            if (healpix.getStatus() != 6 || healpix.pcat == null) continue;
            healpix.pcat.projpcat[n] = null;
        }
    }

    @Override
    protected void reallocObjetCache() {
        Enumeration e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKeyCat healpix = (HealpixKeyCat)e.nextElement();
            if (healpix.getStatus() != 6 || healpix.pcat == null) continue;
            healpix.pcat.reallocObjetCache();
        }
    }

    @Override
    protected int getNbTable() {
        return 1;
    }

    @Override
    protected Vector<Legende> getLegende() {
        Vector<Legende> v = new Vector<Legende>();
        v.addElement(this.getFirstLegende());
        return v;
    }

    @Override
    protected Legende getFirstLegende() {
        return this.genericPcat == null ? null : this.genericPcat.leg;
    }

    protected boolean hasGenericPcat() {
        return this.genericPcat != null;
    }

    protected Pcat getGenericPcat() {
        return this.genericPcat;
    }

    @Override
    protected boolean hasCatalogInfo() {
        return this.hasGenericPcat() && this.genericPcat.hasCatalogInfo();
    }

    protected void setGenericPcat(Pcat pcat) {
        if (pcat == null) {
            return;
        }
        if (this.genericPcat == null) {
            this.genericPcat = pcat;
        }
        if (pcat.hasObj()) {
            try {
                Source src = (Source)pcat.iterator().next();
                if (this.genericPcat.leg == null) {
                    this.genericPcat.leg = src.getLeg();
                }
                if (this.genericPcat.leg == null) {
                    throw new Exception("cannot store pattern in null leg !");
                }
                String[] pattern = src.getValues();
                for (int i = 0; i < this.genericPcat.leg.field.length; ++i) {
                    if (pattern[i].trim().length() == 0) continue;
                    this.genericPcat.leg.field[i].hpxFinderPattern = pattern[i];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadGenericLegende() {
        String filename = this.getUrl() + "/" + "metadata.xml";
        Pcat pcat = new Pcat(this);
        MyInputStream in = null;
        try {
            in = Util.openAnyStream(filename);
            pcat.tableParsing(in, null);
            this.setGenericPcat(pcat);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAllskyExt() {
        String filename = this.getUrl() + "/Norder1/Allsky.tsv";
        MyInputStream in = null;
        try {
            in = Util.openAnyStream(filename);
            this.allskyExt = 2;
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected boolean hasObj() {
        return this.hasSources();
    }

    @Override
    protected boolean hasSources() {
        return this.pixList != null && this.pixList.size() > 0;
    }

    @Override
    protected int getCounts() {
        int n = 0;
        Enumeration e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKeyCat healpix = (HealpixKeyCat)e.nextElement();
            if (healpix.getStatus() != 6) continue;
            n += healpix.pcat != null ? healpix.pcat.getCount() : 0;
        }
        return n;
    }

    @Override
    protected Obj[] getObj() {
        int i;
        int n = this.getCounts();
        Obj[] obj = new Obj[n];
        Iterator<Obj> it = this.iterator();
        for (i = 0; it.hasNext() && i < obj.length; ++i) {
            obj[i] = it.next();
        }
        if (i < obj.length) {
            Obj[] o = new Obj[i];
            System.arraycopy(obj, 0, o, 0, i);
            obj = o;
        }
        return obj;
    }

    @Override
    protected Iterator<Obj> iterator() {
        return new ObjIterator(null);
    }

    @Override
    protected Iterator<Obj> iterator(ViewSimple v) {
        return new ObjIterator(v);
    }

    class ObjIterator
    implements Iterator<Obj> {
        Enumeration<HealpixKey> e = null;
        Iterator<Obj> it = null;
        int order;
        ViewSimple v;

        ObjIterator(ViewSimple v) {
            this.v = v;
            int n = this.order = v != null ? PlanBGCat.this.getCurrentMaxOrder(v) : -1;
            if (this.order == 1) {
                this.order = 2;
            }
        }

        @Override
        public boolean hasNext() {
            while (this.it == null || !this.it.hasNext()) {
                if (this.e == null) {
                    if (PlanBGCat.this.pixList == null) {
                        return false;
                    }
                    this.e = PlanBGCat.this.pixList.elements();
                }
                if (!this.e.hasMoreElements()) {
                    return false;
                }
                HealpixKeyCat healpix = (HealpixKeyCat)this.e.nextElement();
                if (healpix.getStatus() != 6 || this.order != -1 && healpix.order > this.order) continue;
                this.it = healpix.pcat.iterator(this.v);
            }
            return this.it.hasNext();
        }

        @Override
        public void remove() {
        }

        @Override
        public Obj next() {
            while (this.it == null || !this.it.hasNext()) {
                if (this.e == null) {
                    this.e = PlanBGCat.this.pixList.elements();
                }
                if (!this.e.hasMoreElements()) {
                    return null;
                }
                HealpixKeyCat healpix = (HealpixKeyCat)this.e.nextElement();
                if (healpix.getStatus() != 6 || this.order != -1 && healpix.order > this.order) continue;
                this.it = healpix.pcat.iterator(this.v);
            }
            return this.it.next();
        }
    }
}

